// File Transfer
// This sketch works in conjunction with a BASIC
//   progrtam to transfer files from a PC to/from an 
//   Arduino.  It requires QuickCalcBASIC ver 2.5
//   or higher.  Download QuickCalc BASIC and the 
//   file transfer program free from
//   www.quickcalcbasic.com.
// The BASIC program uses QuickCalc BINARY 
//   and SERIAL File I/O.

#include <Arduino.h>
#include <SPI.h>
#include <SD.h>

// program is written for the Mega2560
//#define NANO  // un-comment if Nano

#define DOING_IDLE     0
#define DOING_UPLOAD   1
#define DOING_DEL      2
#define DOING_DOWNLOAD 3
#define DOING_DIR      4
#define DOING_DIRD     5
#define DOING_MKDIR    6
#define DOING_RMDIR    7
#define DOING_EXISTS   8

int   chipSelect;
char  filename        [60];
char  dirPath         [60];
int   dp_count;
char  file_line       [256];
char  message [256];
int   msg_count;
int   bytes_read;
char  file_data [128];
char  filesize_string [18];
char  hash_string     [18];
long  pc_filesize, filesize; 
int   fs_count, ht_count;
char  dl_msg [10];
int   dl_count;
char  command [20];
char  doing, state;
int   fn_count;
int   file_count;
File  outputFile;
File  inputFile;
File  root;
File  dirFile;
File  dirEntry;
char  c;
int   error;
long  pc_hash;
char  retrying;

void setup() 
   {
   int   rc;
   error = false;
   Serial.begin (19200); // must match PC speed
#ifdef NANO
   chipSelect = 10;
#else
   chipSelect = 53;  // mega
#endif   
   pinMode (chipSelect, OUTPUT);
   rc =  SD.begin(chipSelect); 
   if (!rc)
      {
      Serial.println("Card failed, or not present");
      // don't do anything more:
      error = true;
      return;
      }
   doing = DOING_IDLE;
   }

//--------------------------------------------------

void loop() 
   {
   char  temp_message [10];   
   int   count, temp_count, i;
   unsigned int   m;
   unsigned char  c, c2;
   char  *ptr1, *ptr2;
   long  ht, ht2;
   int   bytes_written;
   unsigned char skipping_file;
   
   if (error)
      return;
   switch (doing)
      {
      case DOING_IDLE:
         // Receive command 
         msg_count = get_message_from_PC (&command[0]);
         if (strcmp (command, "upload") == 0)
            {
            doing = DOING_UPLOAD;
            Serial.println ("OK");
            state = 0;
            break;
            }
         if (strcmp (command, "del") == 0)
            {
            doing = DOING_DEL;
            state = 0;
            Serial.println ("OK");
            break;
            }
         if (strcmp (command, "download") == 0)
            {
            doing = DOING_DOWNLOAD;
            Serial.println ("OK");
            state = 0;
            break;
            }
         if (strcmp (command, "dir") == 0)
            {
            doing = DOING_DIR;
            state = 0;
            Serial.println ("OK");
            break;
            }
         if (strcmp (command, "dird") == 0)
            {
            doing = DOING_DIRD;
            state = 0;
            Serial.println ("OK");
            break;
            }
         if (strcmp (command, "mkdir") == 0)
            {
            doing = DOING_MKDIR;
            state = 0;
            Serial.println ("OK");
            break;
            }
         if (strcmp (command, "rmdir") == 0)
            {
            doing = DOING_RMDIR;
            state = 0;
            Serial.println ("OK");
            break;
            }
         if (strcmp (command, "exists") == 0)
            {
            doing = DOING_EXISTS;
            state = 0;
            Serial.println ("OK");
            break;
            }
         else
            {
            Serial.println ("Invalid Command");
            break;
            }
            
      case DOING_UPLOAD:
         switch (state)
            {
            case 0:
               // Receive filename to write
               fn_count = get_message_from_PC (&filename[0]);
               // later - edit filename for correctness

                // First delete the output file, if it exists.
               SD.remove (filename);
               // open the output file
               outputFile = SD.open (filename, FILE_WRITE);
               if (! outputFile)
                  {
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("Could not open output file");
                  break;
                  }
               // File opened successflly
               state = 1;
               Serial.println ("OK");
               break;
               
            case 1:
               // Get file size from PC
               fs_count = get_message_from_PC (&filesize_string[0]);
               pc_filesize = atoi (filesize_string);
               filesize = 0;
               state = 2;
               Serial.println ("OK");
               break;
            
            case 2:
               // receive hash total
               ht_count = get_message_from_PC (&hash_string[0]);
               pc_hash = atol (hash_string);
               if (pc_hash == -1)
                  {   // PC said to cancel
                  outputFile.close();
                  SD.remove (filename);
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  break;
                  }
               state = 3;
               Serial.println ("OK");
               break;
            
            case 3: 
               // receive translated line from PC    
               count = get_message_from_PC (&message[0]);
               // First, calculate the hash total 
               ht = hash_total (&message[0], count);  
               // Calculate the hash total
               ht2 = hash_total (&message[0], count);
               if (ht2 != pc_hash)
                  {
                  state = 2;  // PC should re-send
                  Serial.print ("Hash Total Error ");
                  Serial.print (pc_hash);
                  Serial.print (" ");
                  Serial.println (ht2);
                  break;
                  }
               file_count = un_translate 
                     ((unsigned char *)&message[0], (unsigned char *)&file_line[0]);

               if (file_count == 0)   // end-of-file
                  {
                  outputFile.close();
                  if (pc_filesize != filesize)
                     {
                     SD.remove (filename);
                     state = 0;
                     doing = DOING_IDLE;
                     Serial.print ("Filesize Error ");
                     Serial.print (pc_filesize);
                     Serial.print (" ");
                     Serial.println (filesize);
                     break;
                     }
                  // File copy completed successfully
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  //Serial.println (filesize);
                  break;
                  }
               // We have a good record
               //   record  is in file_line,
               //   length is in file_count.
               // Write the record to the file
               bytes_written = outputFile.write 
                       (file_line, file_count);
               if (bytes_written != file_count)
                  {   // some kind of write error
                  outputFile.close();
                  SD.remove (filename);
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("SD Write error");
                  break;
                  }
               // write was successful
               filesize += file_count;
               state = 2;  // go get hext record
               Serial.println ("OK");
               break;
            default:
               state = 0;
               doing = DOING_IDLE;
               Serial.println ("state error");
               break;
            }  // end switch state 
         break;
 
 //----------------------------------------------
 
      case DOING_DOWNLOAD:
         switch (state)
            {
            case 0:
               // Receive filename to read
               fn_count = get_message_from_PC (&filename[0]);
               // later - edit filename for correctness
               
               // open the input file
               inputFile = SD.open (filename);
               if (! inputFile)
                  {
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("0");  // doesn't exist
                  break;
                  }
               // File opened successflly
               filesize = inputFile.size ();
               state = 1;
               Serial.println (filesize, DEC);
               retrying = false;
               break;
               
            case 1:
               // PC should have open file and responded OK
               dl_count = get_message_from_PC (&dl_msg[0]);
               if (strcmp (dl_msg, "cancel") == 0)
                  {
                  inputFile.close ();
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  break;
                  }
               if (strcmp (dl_msg, "retry") == 0)
                  {
                  retrying = true;
                  }
                  
               // Now we are ready to transmit the file
               state = 2;
               break;
            
            case 2:
               // read a record
               if (! retrying)
                  {
                  bytes_read = read_record ();
                  }
               retrying = false;  
               
               // translate record
              file_count = translate (&file_line[0], 
                     &message[0], bytes_read);
               
               // calculate hash total
               ht = hash_total (&message[0], file_count);  
               
               Serial.println (ht, DEC);
               state = 3;
               break;
    
            case 3: 
               // receive OK or cancel line from PC    
              dl_count = get_message_from_PC (&dl_msg[0]);
              if (strcmp (dl_msg, "cancel") == 0)
                  {
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  break;
                  }
               if (file_count == 0)
                  {
                  // We are at end-of-file
                  inputFile.close();
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println (""); // indicate eof
                  break;
                  }
                  
               // Now send the translated record
              
               state = 1;
               Serial.println (message);
               break;
              
            default:
               state = 0;
               doing = DOING_IDLE;
               Serial.println ("state error");
               break;
            }  // end switch state 
         break;

//-------------------------------- DEL ---------         

      case DOING_DEL:
         // Receive filename to delete
         fn_count = get_message_from_PC (&filename[0]);
         // later - edit filename for correctness
         //  or see if it even exists
 
         // Delete the output file, if it exists.
         SD.remove (filename);
         
         doing = DOING_IDLE;
         state = 0;
         Serial.println ("OK");
         break; 

//-------------------------------- MKDIR ---------         

      case DOING_MKDIR:
         // Receive directory name to create
         // must include full path, e.g., A/B/C
         fn_count = get_message_from_PC (&filename[0]);
         // Create the new directory.
         if (! SD.mkdir (filename))
            {
            // error creating directory
            doing = DOING_IDLE;
            Serial.println ("Error");
            }
         else
            {
            doing = DOING_IDLE;
            Serial.println ("OK");
            }
         break; 

//-------------------------------- RMDIR ---------         

      case DOING_RMDIR:
         // Receive directory name to delete
         // must include full path, e.g., A/B/C
         fn_count = get_message_from_PC (&filename[0]);

         // Remove the directory.
         // Note: Directory must be empty
         if (! SD.rmdir (filename))
            {
            // error deleting directory
            doing = DOING_IDLE;
            Serial.println ("Error");
            }
         else
            {
            doing = DOING_IDLE;
            Serial.println ("OK");
            }
         break; 

//------------------------------- DIR --------         
      case DOING_DIR:
      case DOING_DIRD:
         // Receive path to get directory from
         switch (state)
            {
            case 0:
               dp_count = get_message_from_PC (&dirPath[0]);
               if (strcmp (dirPath, "cancel") == 0)
                  {
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  break;
                  }
               dirFile = SD.open (dirPath);
               if (!dirFile)
                  {
                  // could not open dirPath
                  doing = DOING_IDLE;
                  Serial.println ("bad path"); 
                  break;
                  }
               else
                  {
                  if (! dirFile.isDirectory ())
                     {
                     // then print the file info
                     state = 1;
                     Serial.print (dirEntry.name () );
                     Serial.print (",");
                     Serial.println (dirEntry.size (), DEC);
                     }
                  dirFile.rewindDirectory ();
L1:               skipping_file = false;
                  dirEntry =  dirFile.openNextFile();
                  if (!dirEntry)
                     { // no file. Empty directory
                     dirFile.close ();
                     doing= DOING_IDLE;
                     Serial.println ("done!");
                     break;
                     }
                  // otherwise, we have a file or dir
                  if (dirEntry.isDirectory () ) 
                     {
                     Serial.print (dirEntry.name () );
                     Serial.println ("/");
                     } 
                  else 
                     {
                     // files have sizes, 
                     // directories do not
                     if (doing == DOING_DIR)
                        {
                        Serial.print (dirEntry.name () );
                        Serial.print (",");
                        Serial.println (dirEntry.size (), DEC);
                        }
                     else
                        skipping_file = true;
                     }
                  dirEntry.close ();
                  if (skipping_file)
                     goto L1;  // get next entry
                  state = 1;
                  break;
                  }
               
            case 1: 
               // directory is open.
               // PC should resopond "OK" or "cancel"
               // We will send directory entries until
               //  there are no more, or PC says "Cancel".
               
               dp_count = get_message_from_PC (&dirPath[0]);
               if (strcmp (dirPath, "cancel") == 0)
                  {
                  dirFile.close ();
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("OK");
                  break;
                  }
L2:
               skipping_file = false;
               dirEntry =  dirFile.openNextFile();
               if (!dirEntry)
                  { // no more files
                  dirFile.close ();
                  state = 0;
                  doing = DOING_IDLE;
                  Serial.println ("done!");
                  break;
                  }
               // otherwise, we have a file or dir
               if (dirEntry.isDirectory () ) 
                  {
                  Serial.print (dirEntry.name () );
                  Serial.println ("/");
                  } 
               else 
                  {
                  // files have sizes, 
                  // directories do not
                  if (doing == DOING_DIR)
                     {
                     Serial.print (dirEntry.name () );
                     Serial.print (",");
                     Serial.println (dirEntry.size (), DEC);
                     }
                  else
                     skipping_file = true;
                  }
               dirEntry.close ();
               if (skipping_file)
                  goto L2; // go get next entry                  
               break;
            default:
               break;
            }  // end switch state
         break;
        
//-------------------------------- EXISTS ---------         

      case DOING_EXISTS:
         // Receive filename to check
         fn_count = get_message_from_PC (&filename[0]);
         // try to open the file 
         state = 0;
         doing = DOING_IDLE;
         inputFile = SD.open (filename);
         if (! inputFile)
            {
            Serial.println ("0");  // doesn't exist
            break;
            }
         // Check if the file is a directory
         if (! inputFile.isDirectory ())
            {  // not a directory - must be regular file
            inputFile.close ();      
            Serial.println ("1");
            }
         else  // it is a directory
            {
            inputFile.close ();
            Serial.println ("2");
            }       
         break; 
         
//----------------------------------------------         
      default:
            doing = DOING_IDLE;
            Serial.println ("Error");
            break; 
      }   // end switch doing 
    
   }   // end Loop
      
// ====================================================

long hash_total (char * ptr, int count)
   {
   int   i;
   long  ht;
   unsigned char  c;
   unsigned int   m;
   i = 1;
   ht = 0;
   while (i <= count)
      {
      c = *ptr++;
      m = (int)c * i;
      ht = ht + (long)m;
      i++;
      }
   return ht;
   }
   
//================================================

int   translate (char * ptr1, 
                 char *ptr2, int file_count)
   {
   ptr1 = file_line;
   ptr2 = message;
   int   count;
   char c;
   while (file_count > 0)
      {
      c = *ptr1++;
      if (c == '\0')
         {
         *ptr2 ++ = '\\';
         *ptr2 ++ = '0';
         }
      else
         {
         if (c == '\n')
            {
            *ptr2 ++ = '\\';
            *ptr2 ++ = 'n';
            }
         else
            {
            if (c == '\r')
               {
               *ptr2 ++ = '\\';
               *ptr2 ++ = 'r';
               }
            else
               {
               if (c == '\\')
                  {
                  *ptr2 ++ = '\\';
                  *ptr2 ++ = '\\';
                  }
               else
                  *ptr2 ++ = c;
               }
            }
         }
      file_count --;
      }
   *ptr2 = '\0';
   count = ptr2 - message;
   return count;
   }

//================================================
 
int un_translate (unsigned char * ptr1, unsigned char *ptr2)
   {
   int   count;
   unsigned char  c, c2;
   unsigned char * start;
   
   start = ptr2;
   c = *ptr1++;
   while (c != '\0')
      {
      if (c == '\\')
         {
	 c2 = *ptr1++;	// get char following backslash
	 if (c2 == '0')
	    *ptr2++ = '\0';		// null character (hex 00)
	 else
	    if (c2 == '\\')
               *ptr2++ = '\\';		// back-slash
	    else
               if (c2 == 'n')
                  *ptr2++ = '\n';		// new-line (hex 0A)
               else
                  if (c2 == 'r')
                     *ptr2++ = '\r';		// carriage return (hex 0D)
		     else
                        if (c2 == '\0')		// premature termination of string
			    break;			// don't copy the null
			else
			   *ptr2++ = c2;
         }
      else
         *ptr2++ = c;	// just copy the char
      c = *ptr1++;		// get next char
       
      }

   // When we break out of the WHILE loop, 
   //   ptr2 should be pointing one beyond
   //   the last character copied.  
   //   There is no terminating null.

   count = ptr2 - start;
   return count;
   }

//================================================

int   read_record (void)
   {
   // Read bytes from the file and plugs them
   //   into the array file_line [].
   // Stops after 127 chars.  Does NOT put null
   //   char at end (line may contain nulls).
   // Returns number of bytes read.  0 = eof.
   int   count;
   char * ptr;
   ptr = &file_line [0];
   count = 0;
   while (count < 127)
      {
      if (! inputFile.available ()) 
         break; 
      *ptr++ = inputFile.read ();
      count++; 
      }
   return count;
   }
   
 //-------------------------------------------
 
 int   get_message_from_PC (char *line)
   {
   int   temp_count;
   // temp - get a message from the PC
   while (! Serial.available ());  // wait till ready
   temp_count = Serial.readBytesUntil ('\n',line, 255);
   line [temp_count] = '\0';
   return temp_count;
   }
   
//--------------------------------------------
